const express = require("express");
const multer = require("multer");
const path = require("path");

const db = require("../models");

const OtherFiles = db.other_files;

const upload_storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, "uploads/other_files");
  },
  filename: function (req, file, cb) {
    cb(null, Date.now() + path.extname(file.originalname));
  },
});

const uploadStorage = multer({ storage: upload_storage }).single(
  "document_file"
);

const getOtherFiles = async (req, res) => {
  try {
    const _other_files = await OtherFiles.findAll();

    res.status(200).send(_other_files);
  } catch (err) {
    res.status(404).send(err.message);
  }
};

const createOtherFile = async (req, res) => {
  const { title, isAuthorFile, isRateFile, isEnFile } = req.body;

  const updloadedFile = req.file;

  if (!title && !updloadedFile) {
    return res
      .status(400)
      .json({ error: "Please provide the Full Name and CV file!" });
  }

  try {
    const full_data = {
      title,
      isAuthorFile,
      isRateFile,
      is_en_file: isEnFile,
      url: path.join("uploads/other_files", updloadedFile.filename),
    };
    const _other_file = await OtherFiles.create(full_data);

    return res.status(201).json({
      message: "File has been created successfully.",
      _other_file,
    });
  } catch (err) {
    res.status(500).send(err.message);
  }
};

const updateOtherFile = async (req, res) => {
  const { id } = req.params;
  const { title, isAuthorFile, isRateFile, isEnFile } = req.body;

  const updloadedFile = req.file;

  let full_data = {
    title,
    isAuthorFile,
    isRateFile,
    is_en_file: isEnFile,
  };

  console.log("Uploaded FILE")
  console.log(updloadedFile)

  if (updloadedFile) {
    full_data.url = path.join("uploads/other_files", updloadedFile.filename);
  }

  try {
    const currentOtherFile = await OtherFiles.findByPk(id);
    const updatedFile = await currentOtherFile.update(full_data);
    
    res.status(200).json({
      message: "File has been updated successfully!",
      updated_file: updatedFile,
    });
  } catch (err) {
    return res.status(500).send({ error: err.message });
  }
};

const deleteOtherFile = async (req, res) => {
  try {
    const result = await OtherFiles.destroy({
      where: { id: req.params.id },
    });

    if (result == 1) {
      res.status(200).send("File has been successfully deleted!");
    } else {
      res.status(404).send("File doesn't exist!");
    }
  } catch (err) {
    return res.status(err.status).send({ error: err.message });
  }
};

module.exports = {
  getOtherFiles,
  createOtherFile,
  deleteOtherFile,
  updateOtherFile,
  uploadStorage,
};
