const express = require("express");

const db = require("../models");

const Subscription = db.subscriptions;

const getSubscriptions = async (req, res) => {
  try {
    const subscriptios = await Subscription.findAll({});

    return res.status(201).send(subscriptios);
  } catch (err) {
    return res.status(500).json({ error: err.message });
  }
};

const sendSubscription = async (req, res) => {
  const { email } = req.body;

  try {
    const _subscription = await Subscription.create({
      email: email,
    });

    return res.status(201).json({
      en_message: "Thank you for subscribing!",
      al_message: "Faleminderit per abonimin!",
    });
  } catch (err) {
    return res.status(500).json({ error: err.message });
  }
};

module.exports = {
  getSubscriptions,
  sendSubscription,
};
