const express = require("express");
const board_controller = require("../controllers/boardController.js");
const { verifyAdmin } = require("../utils/verifyToken.js");

const router = express.Router();

router.get("/", board_controller.getBoardUsers);
router.post(
  "/",
  verifyAdmin,
  board_controller.uploadStorage,
  board_controller.createBoardUser
);
router.put(
  "/:id",
  verifyAdmin,
  board_controller.uploadStorage,
  board_controller.updateBoardUser
);
router.delete("/:id", verifyAdmin, board_controller.deleteBoardUser);

module.exports = router;
