const express = require('express')
const calls_controller = require('../controllers/callsController.js')
const { verifyAdmin } = require('../utils/verifyToken.js')

const router = express.Router();

router.get("/", calls_controller.getCalls)
router.post("/", verifyAdmin, calls_controller.uploadFileStorage, calls_controller.createCall)
router.delete("/:id", verifyAdmin, calls_controller.deleteCall)
router.put("/:id", verifyAdmin, calls_controller.uploadFileStorage, calls_controller.updateCall)

module.exports = router