const express = require('express');
const authController = require("../controllers/userController.js");
const { verifyAdmin } = require('../utils/verifyToken.js')

const router = express.Router();

router.post("/register", verifyAdmin, authController.register);
router.post("/login", authController.login);

router.get("/", verifyAdmin, authController.getUsers);

router.delete("/:id", verifyAdmin, authController.deleteUser)

module.exports = router