const express = require("express");
const cors = require("cors");
const dotenv = require("dotenv");
const cookieParser = require("cookie-parser");

const app = express();
dotenv.config();

const app_port = process.env.PORT || 3002;

const apiCorsOptions = {
  origin: "*",
};

// const apiCorsOptions = {
//   origin: [
//     "https://studimegjeografike.edu.al/al",
//     "https://studimegjeografike.edu.al/en",
//     "https://studimegjeografike.edu.al",
//     "https://studimegjeografike.edu.al/",
//   ],
//   methods: ["GET", "POST", "PUT", "DELETE"],
// };

const fileCorsOptions = {
  origin: "*",
  methods: "GET",
};

//Middlewares

app.use(cors(apiCorsOptions));
app.use(cookieParser());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(
  "/uploads/materials",
  cors(fileCorsOptions),
  express.static("./uploads/materials")
);
app.use(
  "/uploads/call-materials",
  cors(fileCorsOptions),
  express.static("./uploads/call-materials")
);
app.use(
  "/uploads/board_cv",
  cors(fileCorsOptions),
  express.static("./uploads/board_cv")
);
app.use(
  "/uploads/other_files",
  cors(fileCorsOptions),
  express.static("./uploads/other_files")
);

// Add Routes here
const materialRoutes = require("./routes/materialsRoute.js");
const categoryRoutes = require("./routes/categoriesRoute.js");
const callRoutes = require("./routes/callsRoute.js");
const authRoutes = require("./routes/userRoutes.js");
const subscriptionRoutes = require("./routes/subscriptionRoutes.js");
const boardRoutes = require("./routes/boardRoutes.js");
const otherFilesRoutes = require("./routes/otherFilesRoutes.js");

app.use("/api/auth", authRoutes);
app.use("/api/materials", materialRoutes);
app.use("/api/categories", categoryRoutes);
app.use("/api/calls", callRoutes);
app.use("/api/subscriptions", subscriptionRoutes);
app.use("/api/board", boardRoutes);
app.use("/api/other-files", otherFilesRoutes);

// Error handling middleware

app.use((err, req, res, next) => {
  const errorStatus = err.status || 500;
  const errorMessage = err.message || "Something went wrong!";

  return res.status(errorStatus).json({
    success: false,
    status: errorStatus,
    message: errorMessage,
    stack: err.stack,
  });
});

app.listen(3002, () => {
  console.log("Server running");
});
