const express = require('express')

const db = require('../models')

const Category = db.categories;


const getCategories = async (req, res) => {
    try {
        const categories = await Category.findAll({})

        return res.status(201).send(categories)
    } catch (err) {
        return res.status(err.status).json({ error: err.message })
    }
}

const createCategory = async (req, res) => {
    const { name } = req.body

    if (!name) {
        return res.status(400).json({ error: "Please provide a name!" })
    }
    try {
        const category = {
            name: name
        }

        const _category = await Category.create(category);

        return res.status(201).json({
            message: "Category created successfully!"
        })
    } catch (err) {
        return res.status(err.status).json({ error: err.message })
    }
}

const updateCategory = async (req, res) => {
    const { id } = req.params;
    const { name } = req.body;

    let updated_data = {
        name: name
    }

    try {
        const current_category = await Category.findByPk(id);
        const updatedCategory = await current_category.update(updated_data);

        res.status(200).json({ message: "Category has been successfully updated!", updatedCategory })
    } catch (err) {
        res.status(500).json({ error: err.message })
    }
}

const deleteCategory = async (req, res) => {
    const { id } = req.params;
    try {
        const result = await Category.destroy({
            where: { id: id }
        })

        if (result == 1) {
            res.status(200).send("Category has been successfully deleted!");
        } else {
            res.status(404).send("Category doesn't exist!")
        }
    } catch (err) {
        res.status(500).json({ error: err.message })
    }
}

module.exports = {
    getCategories,
    createCategory,
    updateCategory,
    deleteCategory
}