const db = require("../models")
const bcrypt = require('bcryptjs')
const jwt = require("jsonwebtoken")

const User = db.users

const register = async (req, res, next) => {
    try {
        const existingUser = await User.findOne({
            where: {
                email: req.body.email
            }
        })

        if (existingUser) {
            throw Error("User already exist")
        }

        const salt = bcrypt.genSaltSync(10);
        const hashed_password = bcrypt.hashSync(req.body.password, salt);

        let data = {
            username: req.body.username,
            email: req.body.email,
            password: hashed_password,
            isAdmin: req.body.isAdmin
        }

        const new_user = await User.create(data);

        res.status(200).json({ success_message: "User has been created!" })
    } catch (err) {
        res.status(500).json({ error_message: err.message })
    }
}

const login = async (req, res, next) => {
    try {
        const user = await User.findOne({
            where: {
                email: req.body.email
            }
        });

        if (!user) return res.status(404).json({ message: "User not found!" });

        const isPasswordCorrect = await bcrypt.compare(req.body.password, user.password);

        if (!isPasswordCorrect) return res.status(400).json({ message: "Wrong credentials" });

        const token = jwt.sign({ id: user.id, isAdmin: user.isAdmin }, process.env.JWT_SECRET);

        const { id, createdAt, updatedAt, password, isAdmin, ...otherDetails } = user.dataValues;


        res
            .cookie("access_token", token, {
                httpOnly: true,
            })
            .status(200)
            .json({ user_details: { ...otherDetails }, isAdmin: isAdmin, access_token: token });

    } catch (err) {
        return res.status(500).send(err.message)
    }
}

const getUsers = async (req, res, next) => {
    try {
        const _users = await User.findAll({
            attributes: { exclude: ['password', 'isAdmin'] },
        });

        return res.status(200).json(_users)
    } catch (err) {
        next(err)
    }
}

const deleteUser = async (req, res, next) => {
    const { id } = req.params;

    try {
        const result = await User.destroy({
            where: { id: id }
        })

        if (result == 1) {
            res.status(200).send("User has been successfully deleted!");
        } else {
            res.status(404).send("User doesn't exist!")
        }
    } catch (err) {
        next(err)
    }
}

module.exports = {
    register,
    login,
    getUsers,
    deleteUser
}