const dbConfig = require("../config/dbConfig.js");

const { Sequelize, DataTypes } = require("sequelize");

const sequelize = new Sequelize(dbConfig.DB, dbConfig.USER, dbConfig.PASSWORD, {
  host: dbConfig.HOST,
  dialect: dbConfig.dialect,
  operatorsAliases: false,

  pool: {
    max: dbConfig.pool.max,
    min: dbConfig.pool.min,
    acquire: dbConfig.pool.acquire,
    idle: dbConfig.pool.idle,
  },
});

sequelize
  .authenticate()
  .then(() => {
    console.log("Authenticated");
  })
  .catch((err) => console.log("err", err));

const db = {};

db.Sequelize = Sequelize;
db.sequelize = sequelize;

db.users = require("./userModel.js")(sequelize, DataTypes);
db.materials = require("./materialsModel.js")(sequelize, DataTypes);
db.categories = require("./categoryModel.js")(sequelize, DataTypes);
db.calls = require("./callsModel.js")(sequelize, DataTypes);
db.callFiles = require("./callFiles.js")(sequelize, DataTypes);
db.subscriptions = require("./subscriptionModel.js")(sequelize, DataTypes);
db.board_user = require("./boardUser.js")(sequelize, DataTypes);
db.other_files = require("./otherFiles.js")(sequelize, DataTypes);

db.sequelize.sync({ force: false }).then(() => {
  console.log("yes re-sync done!");
});

db.categories.hasMany(db.materials, {
  foreignKey: "categoryId",
});

db.materials.belongsTo(db.categories, {
  foreignKey: "categoryId",
});

db.calls.hasMany(db.callFiles, {
  foreignKey: "call_id",
  as: "call_files",
});

db.callFiles.belongsTo(db.calls, {
  foreignKey: "call_id",
  as: "calls",
});

module.exports = db;
