const express = require('express')
const category_controller = require('../controllers/categoriesController.js')
const { verifyAdmin } = require('../utils/verifyToken.js')

const router = express.Router();

router.get("/", category_controller.getCategories)
router.post("/", verifyAdmin, category_controller.createCategory)
router.put("/:id", verifyAdmin, category_controller.updateCategory)
router.delete("/:id", verifyAdmin, category_controller.deleteCategory)
module.exports = router