const express = require('express')
const materials_controller = require('../controllers/materialsController.js');
const { verifyAdmin } = require('../utils/verifyToken.js')


const router = express.Router();

router.get("/", materials_controller.getMaterials)
router.post("/", verifyAdmin, materials_controller.uploadFields, materials_controller.createMaterial)
router.put("/:id", verifyAdmin, materials_controller.uploadFields, materials_controller.updateMaterial)
router.delete("/:id", verifyAdmin, materials_controller.deleteMaterial)

module.exports = router