const express = require("express");
const other_files_controller = require("../controllers/otherFilesController.js");
const { verifyAdmin } = require("../utils/verifyToken.js");

const router = express.Router();

router.get("/", other_files_controller.getOtherFiles);

router.post(
  "/",
  verifyAdmin,
  other_files_controller.uploadStorage,
  other_files_controller.createOtherFile
);

router.put(
  "/:id",
  verifyAdmin,
  other_files_controller.uploadStorage,
  other_files_controller.updateOtherFile
);
router.delete("/:id", verifyAdmin, other_files_controller.deleteOtherFile);

module.exports = router;
