const jwt = require('jsonwebtoken')

const verifyToken = (req, res, next) => {
    const bearerHeader = req.headers["authorization"];
    if (typeof bearerHeader !== "undefined") {
        const bearerToken = bearerHeader.split(" ")[1];
        jwt.verify(bearerToken, process.env.JWT_SECRET, (err, decoded) => {
            if (err) {
                return res.status(401).json({ message: "Invalid Token" })
            } else {
                req.user = decoded.user;
                next();
            }
        });
    } else {
        return res.status(401).json({ message: "Token not provided!" });
    }
}

const verifyAdmin = (req, res, next) => {
    verifyToken(req, res, next, () => {
        if (req.user.isAdmin) {
            next()
        } else {
            return res.status(403).json({ message: "You are not authorized!" })
        }
    });
}

module.exports = {
    verifyAdmin
}